
from openai import OpenAI
import csv
from tqdm import tqdm

path_to_openai_key = '/Users/piech/Documents/Keys/openai.txt'
client = OpenAI(
    # This is the default and can be omitted
    api_key=open(path_to_openai_key, 'r').readline().strip()
)

def main():
    reader = csv.reader(open('animals.csv', 'r'))
    header = next(reader)
    questions = header[2:]
    writer = csv.writer(open('filled_in_questions.csv', 'w'))
    writer.writerow(header)
    for row in tqdm(reader):
        animal = row[0]
        probability = row[1]
        responses = []
        for i, question in enumerate(questions):
            prompt = f"Consider a {animal}. {question} Answer with one word, yes or no."
            response = gpt_call(prompt)
            responses.append(response)
        writer.writerow([animal, probability] + responses)
    
    


def gpt_call(prompt):

    messages = [
        {
            "role": "user",
            "content": [
                {"type": "text", "text": prompt}
            ]
        }
    ]
    chat_completion = client.chat.completions.create(
        messages=messages,
        model="gpt-4o",
        # response_format={"type": "json_object"},
    )

    raw_response = chat_completion.choices[0].message.content
    raw_response = raw_response.replace('```', '')
    raw_response = raw_response.replace('"', '')
    raw_response = raw_response.replace("'", '')
    raw_response = raw_response.replace(".", '')
    raw_response = raw_response.replace('json', '')
    raw_response = raw_response.strip()
    raw_response = raw_response.lower()
    return raw_response


if __name__ == '__main__':
    main()